using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VIRP.AHOBPR.BO;
using VIRP.AHOBPR.DAL;

namespace VIRP.AHOBPR.BLL
{
	public static partial class STD_DEPLOYMENT_LOCATIONManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static STD_DEPLOYMENT_LOCATION GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_DEPLOYMENT_LOCATION_ID)
		{
			STD_DEPLOYMENT_LOCATION objReturn = null;
			STD_DEPLOYMENT_LOCATIONDB objDB = new STD_DEPLOYMENT_LOCATIONDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, STD_DEPLOYMENT_LOCATION_ID);

			return objReturn;
		}

		public static List<STD_DEPLOYMENT_LOCATION> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<STD_DEPLOYMENT_LOCATION> objReturn = null;
			STD_DEPLOYMENT_LOCATIONDB objDB = new STD_DEPLOYMENT_LOCATIONDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
		}

		public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_DEPLOYMENT_LOCATION objSave)
		{
			Int32 objReturn = 0;
			STD_DEPLOYMENT_LOCATIONDB objDB = new STD_DEPLOYMENT_LOCATIONDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_DEPLOYMENT_LOCATION_ID)
		{
			Boolean objReturn = false;
			STD_DEPLOYMENT_LOCATIONDB objDB = new STD_DEPLOYMENT_LOCATIONDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, STD_DEPLOYMENT_LOCATION_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_DEPLOYMENT_LOCATION objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.STD_DEPLOYMENT_LOCATION_ID);
		}

        public static BprDeploymentLocation[] GetDeploymentLocations(string searchCriteria)
        {
            if (string.IsNullOrEmpty(searchCriteria))
            {
                return (new List<BprDeploymentLocation>()).ToArray();
            }
            else
            {
                List<STD_DEPLOYMENT_LOCATION> locations = GetItems(string.Empty, 0);
                if (locations != null)
                {
                    string[] searches = searchCriteria.Split(' ');

                    if (searches.Length == 1)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();

                    }
                    else if (searches.Length == 2)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 3)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 4)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                        && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                        && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 5)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                         && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                         && (e.NAMES.Contains(searches[4]) || e.COUNTRY.Contains(searches[4]) || e.BASE.Contains(searches[4])
                                            || e.PROVINCE.Contains(searches[4]) || e.OTHER_NAMES.Contains(searches[4]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                }

                List<BprDeploymentLocation> bprLocations = new List<BprDeploymentLocation>();
                foreach (STD_DEPLOYMENT_LOCATION location in locations)
                {
                    BprDeploymentLocation bprLocation = new BprDeploymentLocation();
                    bprLocation.@base = location.BASE;
                    bprLocation.names = location.NAMES;
                    bprLocation.otherNames = location.OTHER_NAMES;
                    bprLocation.province = location.PROVINCE;
                    bprLocation.country = location.COUNTRY;

                    bprLocations.Add(bprLocation);
                }

                return bprLocations.ToArray();
            }
        }

        public static BprDeploymentBaseName[] GetDeploymentBaseNames(string searchCriteria)
        {
            if (string.IsNullOrEmpty(searchCriteria))
            {
                return (new List<BprDeploymentBaseName>()).ToArray();
            }
            else
            {
                List<STD_DEPLOYMENT_LOCATION> locations = GetItems(string.Empty, 0);
                if (locations != null)
                {
                    string[] searches = searchCriteria.Split(' ');

                    if (searches.Length == 1)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();

                    }
                    else if (searches.Length == 2)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 3)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 4)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                        && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                        && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 5)
                    {
                        locations = (from e in locations
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                         && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                         && (e.NAMES.Contains(searches[4]) || e.COUNTRY.Contains(searches[4]) || e.BASE.Contains(searches[4])
                                            || e.PROVINCE.Contains(searches[4]) || e.OTHER_NAMES.Contains(searches[4]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                }

                List<BprDeploymentBaseName> bprBaseNames = new List<BprDeploymentBaseName>();
                foreach (STD_DEPLOYMENT_LOCATION location in locations)
                {
                    BprDeploymentBaseName bprBase = new BprDeploymentBaseName();
                    bprBase.@base = location.BASE + (string.IsNullOrEmpty(location.NAMES) || location.NAMES.ToLower() == "none" ? "" : " (" + location.NAMES + ")");
                    bprBaseNames.Add(bprBase);
                }

                return bprBaseNames.ToArray();
            }
        }

        #endregion
    }
}
